/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.peers.sip.core.useragent.handlers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TimerTask;
import net.sourceforge.peers.Logger;
import net.sourceforge.peers.sip.core.useragent.UserAgent;
import net.sourceforge.peers.sip.core.useragent.handlers.MethodHandler;
import net.sourceforge.peers.sip.syntaxencoding.NameAddress;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldMultiValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderFieldValue;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaderParamName;
import net.sourceforge.peers.sip.syntaxencoding.SipHeaders;
import net.sourceforge.peers.sip.transaction.Transaction;
import net.sourceforge.peers.sip.transaction.TransactionManager;
import net.sourceforge.peers.sip.transactionuser.Dialog;
import net.sourceforge.peers.sip.transactionuser.DialogManager;
import net.sourceforge.peers.sip.transport.SipRequest;
import net.sourceforge.peers.sip.transport.SipResponse;
import net.sourceforge.peers.sip.transport.TransportManager;

public abstract class DialogMethodHandler
extends MethodHandler {
    protected DialogManager dialogManager;

    public DialogMethodHandler(UserAgent userAgent, DialogManager dialogManager, TransactionManager transactionManager, TransportManager transportManager, Logger logger) {
        super(userAgent, transactionManager, transportManager, logger);
        this.dialogManager = dialogManager;
    }

    protected Dialog buildDialogForUas(SipResponse sipResponse, SipRequest sipRequest) {
        SipHeaders reqHeaders = sipRequest.getSipHeaders();
        SipHeaders respHeaders = sipResponse.getSipHeaders();
        SipHeaderFieldName recordRouteName = new SipHeaderFieldName("Record-Route");
        SipHeaderFieldValue reqRecRoute = reqHeaders.get(recordRouteName);
        if (reqRecRoute != null) {
            respHeaders.add(recordRouteName, reqRecRoute);
        }
        SipHeaderFieldName contactName = new SipHeaderFieldName("Contact");
        Dialog dialog = this.dialogManager.createDialog(sipResponse);
        SipHeaderFieldValue recordRoute = respHeaders.get(new SipHeaderFieldName("Record-Route"));
        ArrayList<String> routeSet = new ArrayList<String>();
        if (recordRoute != null) {
            if (recordRoute instanceof SipHeaderFieldMultiValue) {
                SipHeaderFieldMultiValue multiRecordRoute = (SipHeaderFieldMultiValue)recordRoute;
                for (SipHeaderFieldValue routeValue : multiRecordRoute.getValues()) {
                    routeSet.add(routeValue.getValue());
                }
            } else {
                routeSet.add(recordRoute.getValue());
            }
        }
        dialog.setRouteSet(routeSet);
        SipHeaderFieldValue reqContact = reqHeaders.get(contactName);
        String remoteTarget = reqContact.getValue();
        if (remoteTarget.indexOf(60) > -1) {
            remoteTarget = NameAddress.nameAddressToUri(remoteTarget);
        }
        dialog.setRemoteTarget(remoteTarget);
        SipHeaderFieldName cseqName = new SipHeaderFieldName("CSeq");
        SipHeaderFieldValue cseq = reqHeaders.get(cseqName);
        String remoteCseq = cseq.getValue().substring(0, cseq.getValue().indexOf(32));
        dialog.setRemoteCSeq(Integer.parseInt(remoteCseq));
        SipHeaderFieldName callidName = new SipHeaderFieldName("Call-ID");
        SipHeaderFieldValue callid = reqHeaders.get(callidName);
        dialog.setCallId(callid.getValue());
        SipHeaderFieldName toName = new SipHeaderFieldName("To");
        SipHeaderFieldValue to = respHeaders.get(toName);
        SipHeaderParamName tagName = new SipHeaderParamName("tag");
        String toTag = to.getParam(tagName);
        dialog.setLocalTag(toTag);
        SipHeaderFieldName fromName = new SipHeaderFieldName("From");
        SipHeaderFieldValue from = reqHeaders.get(fromName);
        String fromTag = from.getParam(tagName);
        dialog.setRemoteTag(fromTag);
        String remoteUri = from.getValue();
        if (remoteUri.indexOf(60) > -1) {
            remoteUri = NameAddress.nameAddressToUri(remoteUri);
        }
        dialog.setRemoteUri(remoteUri);
        String localUri = to.getValue();
        if (localUri.indexOf(60) > -1) {
            localUri = NameAddress.nameAddressToUri(localUri);
        }
        dialog.setLocalUri(localUri);
        return dialog;
    }

    protected Dialog buildOrUpdateDialogForUac(SipResponse sipResponse, Transaction transaction) {
        SipHeaderFieldValue requestFrom;
        String localUri;
        ArrayList<String> routeSet;
        SipHeaders headers = sipResponse.getSipHeaders();
        Dialog dialog = this.dialogManager.getDialog(sipResponse);
        if (dialog == null) {
            dialog = this.dialogManager.createDialog(sipResponse);
        }
        if ((routeSet = this.computeRouteSet(headers)) != null) {
            dialog.setRouteSet(routeSet);
        }
        SipHeaderFieldValue contact = headers.get(new SipHeaderFieldName("Contact"));
        this.logger.debug("Contact: " + contact);
        if (contact != null) {
            String remoteTarget = NameAddress.nameAddressToUri(contact.toString());
            dialog.setRemoteTarget(remoteTarget);
        }
        SipHeaders requestSipHeaders = transaction.getRequest().getSipHeaders();
        String requestCSeq = requestSipHeaders.get(new SipHeaderFieldName("CSeq")).toString();
        requestCSeq = requestCSeq.substring(0, requestCSeq.indexOf(32));
        dialog.setLocalCSeq(Integer.parseInt(requestCSeq));
        SipHeaderFieldValue to = headers.get(new SipHeaderFieldName("To"));
        if (to != null) {
            String remoteUri = to.getValue();
            if (remoteUri.indexOf(60) > -1) {
                remoteUri = NameAddress.nameAddressToUri(remoteUri);
            }
            dialog.setRemoteUri(remoteUri);
        }
        if ((localUri = (requestFrom = requestSipHeaders.get(new SipHeaderFieldName("From"))).getValue()).indexOf(60) > -1) {
            localUri = NameAddress.nameAddressToUri(localUri);
        }
        dialog.setLocalUri(localUri);
        return dialog;
    }

    protected ArrayList<String> computeRouteSet(SipHeaders headers) {
        SipHeaderFieldValue recordRoute = headers.get(new SipHeaderFieldName("Record-Route"));
        ArrayList<String> routeSet = new ArrayList<String>();
        if (recordRoute != null) {
            if (recordRoute instanceof SipHeaderFieldMultiValue) {
                List<SipHeaderFieldValue> values = ((SipHeaderFieldMultiValue)recordRoute).getValues();
                for (SipHeaderFieldValue value : values) {
                    routeSet.add(0, value.toString());
                }
            } else {
                routeSet.add(recordRoute.toString());
            }
        }
        return routeSet;
    }

    class AckTimerTask
    extends TimerTask {
        private String toUri;

        public AckTimerTask(String toUri) {
            this.toUri = toUri;
        }

        @Override
        public void run() {
            ArrayList<Dialog> purgedDialogs = new ArrayList<Dialog>();
            Collection<Dialog> dialogs = DialogMethodHandler.this.dialogManager.getDialogCollection();
            for (Dialog dialog : dialogs) {
                String remoteUri = dialog.getRemoteUri();
                if (!remoteUri.equals(this.toUri) || dialog.CONFIRMED.equals(dialog.getState())) continue;
                dialog.receivedOrSentBye();
                purgedDialogs.add(dialog);
            }
            for (Dialog dialog : purgedDialogs) {
                dialogs.remove(dialog);
            }
        }
    }
}

